﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows.Controls;

using Hosui.Controls;

namespace Hosui.TextEditor
{
    public class DictionaryFile : PropertyChangedBase, IEditableFile
    {
        public DictionaryFile()
        {
            InitializeComponent();
            _isModified = true;
            _editor.TextEditor.SetHighlighting("KAWARI");
            _editor.TextEditor.Document.DocumentChanged += (_, __) => IsModified = true;
        }

        public DictionaryFile(string path)
        {
            InitializeComponent();
            _fullPath = path;
            _fileName = Path.GetFileName(path);
            LoadFile(path);
            if (_fileName == "dict-keeps-savedata.txt")
            {
                _editor.TextEditor.SetHighlighting("KAWARI");
            }
            _editor.TextEditor.TextChanged += (_, __) => IsModified = true;
        }

        private string _fullPath;

        public string FullPath
        {
            get { return _fullPath; }
            set
            {
                if (_fullPath != value)
                {
                    _fullPath = value;
                    OnPropertyChanged("FullPath");
                }
            }
        }

        private string _fileName;

        public string FileName
        {
            get { return _fileName; }
            set
            {
                if (_fileName != value)
                {
                    _fileName = value;
                    OnPropertyChanged("FileName");
                }
            }
        }

        private CodeEditorControl _editor;

        public CodeEditorControl Editor
        {
            get { return _editor; }
        }

        private bool _isModified = false;

        public bool IsModified
        {
            get { return _isModified; }
            private set
            {
                if (_isModified != value)
                {
                    _isModified = value;
                    OnPropertyChanged("IsModified");
                }
            }
        }

        public bool LoadFile(string path)
        {
            try
            {
                _editor.TextEditor.LoadFile(path);
            }
            catch
            {
                return false;
            }
            return true;
        }

        public bool SaveFile()
        {
            if (string.IsNullOrEmpty(_fullPath))
            {
                var dialog = new System.Windows.Forms.SaveFileDialog
                {
                    AddExtension = true,
                    Filter = "華和梨辞書ファイル|*.kis|AYA 辞書ファイル|*.dic|すべてのファイル|*.*",
                    FilterIndex = 0,
                };
                if (dialog.ShowDialog() == System.Windows.Forms.DialogResult.Cancel)
                {
                    return false;
                }
                _fullPath = dialog.FileName;
            }
            return SaveFile(_fullPath);
        }

        public bool SaveFile(string path)
        {
            try
            {
                _editor.TextEditor.SaveFile(path);
            }
            catch
            {
                return false;
            }
            IsModified = false;
            return true;
        }

        public static bool IsEditableFile(string path)
        {
            return Regex.IsMatch(path, @"\.(kis|txt|dic|aym)$", RegexOptions.IgnoreCase);
        }

        private void InitializeComponent()
        {
            // コントロール作成
            _editor = new CodeEditorControl();
            _editor.TextEditor.Font = new System.Drawing.Font("MS Gothic", 9);
        }
    }
}