﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Linq;
using System.Text;
using System.Windows;
using System.Xml.Serialization;

namespace Hosui
{
    [XmlRoot("Hosui"), Serializable]
    public class Settings : PropertyChangedBase
    {
        public Settings()
        {
        }

        public Point Location { get; set; }

        public Size Size { get; set; }

        public WindowState WindowState { get; set; }

        public double SideWidth { get; set; }

        public double MainRowHeight { get; set; }

        public double SideRowHeight { get; set; }

        private readonly ObservableCollection<string> _recentProjects = new ObservableCollection<string>();

        public ObservableCollection<string> RecentProjects
        {
            get { return _recentProjects; }
        }

        private static readonly XmlSerializer xs = new XmlSerializer(typeof(Settings));

        public static Settings Current { get; private set; }

        public static void Load(string path)
        {
            if (!File.Exists(path))
            {
                Current = new Settings();
                return;
            }
            using (var fs = File.Open(path, FileMode.Open))
            {
                Current = (Settings)xs.Deserialize(fs);
            }
        }

        public static void Save(string path)
        {
            using (var fs = File.Open(path, FileMode.Create))
            {
                xs.Serialize(fs, Current);
            }
        }
    }
}
