﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.IO;
using System.Linq;
using System.Text;

namespace Hosui.IO
{
    public class FolderEntry : FileEntry
    {
        public FolderEntry(string path)
            : base(path)
        {
            _dirInfo = new DirectoryInfo(path);
        }

        private DirectoryInfo _dirInfo;

        private ObservableCollection<FileEntry> _items;

        public ObservableCollection<FileEntry> Items
        {
            get
            {
                if (_items == null)
                {
                    _items = new ObservableCollection<FileEntry>();
                    foreach (var item in _dirInfo.GetDirectories())
                    {
                        _items.Add(new FolderEntry(item.FullName));
                    }
                    foreach (var item in _dirInfo.GetFiles())
                    {
                        _items.Add(new FileEntry(item.FullName));
                    }
                }
                return _items;
            }
        }
    }
}
