﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Hosui.Debugger
{
    public class Function : PropertyChangedBase, IEquatable<Function>, IComparable<Function>
    {
        public Function(string name)
        {
            _name = name;
        }

        private string _name;

        public string Name
        {
            get { return _name; }
            set
            {
                if (_name != value)
                {
                    _name = value;
                    OnPropertyChanged("Name");
                }
            }
        }

        #region IComparable<Function> メンバ

        public int CompareTo(Function other)
        {
            return Comparer<string>.Default.Compare(this.Name, other.Name);
        }

        #endregion

        #region IEquatable<Function> メンバ

        public bool Equals(Function other)
        {
            return this.Name == other.Name;
        }

        #endregion
    }
}
