﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace Hosui.TextEditor
{
    static class TaskListParser
    {
        public static IEnumerable<Task> ParseTasks(IEnumerable<string> files)
        {
            List<Task> tasks = new List<Task>();
            foreach (var file in files)
            {
                using (var reader = new StreamReader(file, Encoding.Default))
                {
                    int count = 1;
                    bool inComment = false;
                    while (reader.Peek() != -1)
                    {
                        var line = reader.ReadLine().Trim();
                        if (line.StartsWith(":rem"))
                        {
                            inComment = true;
                        }
                        else if (line.StartsWith(":endrem"))
                        {
                            inComment = false;
                        }
                        else if (inComment || line.StartsWith("#"))
                        {
                            line = line.StartsWith("#") ? line.Substring(1).Trim() : line;
                            if (line.StartsWith("TODO:") || line.StartsWith("UNDONE:") || line.StartsWith("HACK:"))
                            {
                                tasks.Add(new Task(line, file, count));
                            }
                        }
                        ++count;
                    }
                }
            }
            return tasks;
        }
    }
}
