﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Input;

namespace Hosui.Input
{
    public static class Commands
    {
        static Commands()
        {
            _startDebug.InputGestures.Add(new KeyGesture(Key.F5));
            _openProject.InputGestures.Add(new KeyGesture(Key.O, ModifierKeys.Shift | ModifierKeys.Control));
        }

        private static readonly RoutedCommand _startDebug = new RoutedCommand("StartDebug", typeof(Commands));

        public static RoutedCommand StartDebug
        {
            get { return Commands._startDebug; }
        }

        private static readonly RoutedCommand _pauseDebug = new RoutedCommand("PauseDebug", typeof(Commands));

        public static RoutedCommand PauseDebug
        {
            get { return Commands._pauseDebug; }
        }

        private static readonly RoutedCommand _stopDebug = new RoutedCommand("StopDebug", typeof(Commands));

        public static RoutedCommand StopDebug
        {
            get { return Commands._stopDebug; }
        }

        private static readonly RoutedCommand _restartDebug = new RoutedCommand("RestartDebug", typeof(Commands));

        public static RoutedCommand RestartDebug
        {
            get { return Commands._restartDebug; }
        }

        private static readonly RoutedCommand _attachDebug = new RoutedCommand("AttachDebug", typeof(Commands));

        public static RoutedCommand AttachDebug
        {
            get { return Commands._attachDebug; }
        }

        private static readonly RoutedCommand _openProject = new RoutedCommand("OpenProject", typeof(Commands));

        public static RoutedCommand OpenProject
        {
            get { return Commands._openProject; }
        }

        private static readonly RoutedCommand _saveAll = new RoutedCommand("SaveAll", typeof(Commands));

        public static RoutedCommand SaveAll
        {
            get { return Commands._saveAll; }
        }

        private static readonly RoutedCommand _closeTab = new RoutedCommand("CloseTab", typeof(Commands));

        public static RoutedCommand CloseTab
        {
            get { return Commands._closeTab; }
        }

        private static readonly RoutedCommand _recentProject = new RoutedCommand("RecentProject", typeof(Commands));

        public static RoutedCommand RecentProject
        {
            get { return Commands._recentProject; }
        }
    }
}
