﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Windows;
using System.Windows.Interop;
using System.Runtime.InteropServices;

namespace Hosui.Debugger
{
    class RemoteModule : AbstractModule
    {
        public RemoteModule(IntPtr handle, Window owner)
        {
            _handle = handle;
            _source = HwndSource.FromHwnd(new WindowInteropHelper(owner).Handle);
            _source.AddHook(WindowProc);
        }

        private IntPtr _handle;

        private HwndSource _source;

        private AutoResetEvent _signal = new AutoResetEvent(false);

        private string _response;

        #region IDisposable メンバ

        public override void Dispose()
        {
            _source.RemoveHook(WindowProc);
            _handle = IntPtr.Zero;
        }

        #endregion

        private IntPtr WindowProc(IntPtr hwnd, int msg, IntPtr wparam, IntPtr lparam, ref bool handled)
        {
            if (msg == NativeMethods.WM_COPYDATA)
            {
                var cds = (NativeMethods.COPYDATASTRUCT)Marshal.PtrToStructure(lparam, typeof(NativeMethods.COPYDATASTRUCT));
                _response = Marshal.PtrToStringAnsi(cds.lpData, cds.cbData);
                _signal.Set();
                handled = true;
                return (IntPtr)1;
            }
            return IntPtr.Zero;
        }

        public override string Debug(string request)
        {
            var h = Marshal.StringToHGlobalAnsi(request);
            int len = Encoding.Default.GetByteCount(request);
            var cds = new NativeMethods.COPYDATASTRUCT { dwData = 9801, cbData = len, lpData = h };
            NativeMethods.SendDirectSSTP(_handle, NativeMethods.WM_COPYDATA, _source.Handle, ref cds);
            Marshal.FreeHGlobal(h);
            _signal.WaitOne(10000);
            return _response;
        }
    }
}
