﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;

namespace Hosui.Debugger
{
    class LocalModule : AbstractModule
    {
        public LocalModule(string directory)
        {
            // load を呼び出す
            var h = Marshal.StringToHGlobalAnsi(directory);
            load(h, Encoding.Default.GetByteCount(directory));
        }

        [DllImport("Hosui.Kawari.dll")]
        private static extern bool load(IntPtr h, int len);

        [DllImport("Hosui.Kawari.dll")]
        private static extern bool unload();

        [DllImport("Hosui.Kawari.dll")]
        private static extern IntPtr debug(IntPtr h, ref int len);

        #region IDisposable メンバ

        public override void Dispose()
        {
            unload();
        }

        #endregion

        public override string Debug(string request)
        {
            var h = Marshal.StringToHGlobalAnsi(request);
            int len = Encoding.Default.GetByteCount(request);
            h = debug(h, ref len);
            if (h == IntPtr.Zero)
            {
                return string.Empty;
            }
            var res = Marshal.PtrToStringAnsi(h, len);
            Marshal.FreeHGlobal(h);
            return res;
        }
    }
}
