﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace Hosui.Debugger
{
    /// <summary>
    /// EntryDialog.xaml の相互作用ロジック
    /// </summary>
    public partial class EntryDialog : Window
    {
        public EntryDialog()
        {
            InitializeComponent();
        }

        public Entry Entry
        {
            get { return (Entry)GetValue(EntryProperty); }
            set { SetValue(EntryProperty, value); }
        }

        public static readonly DependencyProperty EntryProperty =
            DependencyProperty.Register("Entry", typeof(Entry), typeof(EntryDialog));

        private void OkButton_Click(object sender, RoutedEventArgs e)
        {
            if (Entry != null)
            {
                BindingGroup.CommitEdit();
            }
            else
            {
                Entry = new Entry(name.Text, values.Text.Split('\n').Select(p => p.Trim()).ToArray());
            }
            DialogResult = true;
        }

        private void CancelButton_Click(object sender, RoutedEventArgs e)
        {
            if (Entry != null)
            {
                BindingGroup.CancelEdit();
            }
            DialogResult = false;
        }

        private void EntryDialog_Loaded(object sender, RoutedEventArgs e)
        {
            if (Entry != null)
            {
                BindingGroup.BeginEdit();
            }
        }
    }
}
