﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Collections.Specialized;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Windows.Data;

namespace Hosui.Debugger
{
    public class Entry : PropertyChangedBase, IEquatable<Entry>, IComparable<Entry>
    {
        public Entry(string name, params string[] values)
            : this(name, null, values)
        {
        }

        public Entry(string name, Entry parent, params string[] values)
        {
            _name = name;
            _parent = parent;
            _values = values;
            if (_values != null)
            {
                var val = string.Join(",\r\n", _values);
                _value = val.Length == 0 ? null : val;
            }
            _isArray = _values != null ? _values.Length > 1 : false;
            _subEntriesView = new ListCollectionView(_subEntries);
            _subEntriesView.SortDescriptions.Add(new SortDescription("Name", ListSortDirection.Ascending));
        }

        private string _name;

        public string Name
        {
            get { return _name; }
            set
            {
                if (_name != value)
                {
                    _name = value;
                    _fullPath = null;
                    OnPropertyChanged("Name");
                }
            }
        }

        private readonly Entry _parent;

        public Entry Parent
        {
            get { return _parent; }
        }

        private string _fullPath = null;

        public string FullPath
        {
            get
            {
                if (_fullPath == null)
                {
                    var entry = _parent;
                    var list = new List<string>();
                    list.Add(Name);
                    while (entry != null)
                    {
                        list.Add(entry.Name);
                        entry = entry.Parent;
                    }
                    _fullPath = string.Join(".", Enumerable.Reverse(list).ToArray());
                }
                return _fullPath;
            }
        }

        private string _value;

        public string Value
        {
            get { return _value; }
            set
            {
                if (_value != value)
                {
                    _value = value;
                    OnPropertyChanged("Value");
                    if (_value != null)
                    {
                        _values = _value.Split('\n').Select(p => p.Trim()).ToArray();
                        IsArray = _values != null ? _values.Length > 1 : false;
                    }
                }
            }
        }

        private string[] _values;

        public string[] Values
        {
            get { return _values; }
            set
            {
                if (_values != value)
                {
                    _values = value;
                    OnPropertyChanged("Values");
                    if (_values != null)
                    {
                        var val = string.Join(",\r\n", _values);
                        _value = val.Length == 0 ? null : val;
                    }
                    IsArray = _values != null ? _values.Length > 1 : false;
                }
            }
        }

        private bool _isArray;

        public bool IsArray
        {
            get { return _isArray; }
            set
            {
                if (_isArray != value)
                {
                    _isArray = value;
                    OnPropertyChanged("IsArray");
                }
            }
        }

        private readonly ObservableCollection<Entry> _subEntries = new ObservableCollection<Entry>();

        public ObservableCollection<Entry> SubEntries
        {
            get { return _subEntries; }
        }

        private readonly ListCollectionView _subEntriesView;

        public ListCollectionView SubEntriesView
        {
            get { return _subEntriesView; }
        }

        #region IComparable<Variable> メンバ

        public int CompareTo(Entry other)
        {
            return Comparer<string>.Default.Compare(this.Name, other.Name);
        }

        #endregion

        #region IEquatable<Variable> メンバ

        public bool Equals(Entry other)
        {
            return this.FullPath == other.FullPath;
        }

        #endregion
    }
}
