﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Interop;
using System.Runtime.InteropServices;

namespace Hosui.Debugger
{
    /// <summary>
    /// AttachDialog.xaml の相互作用ロジック
    /// </summary>
    public partial class AttachDialog : Window
    {
        public AttachDialog()
        {
            InitializeComponent();
        }

        private HwndSource _source;

        private readonly ObservableCollection<AttachEntry> _entries = new ObservableCollection<AttachEntry>();

        public ObservableCollection<AttachEntry> Entries
        {
            get { return _entries; }
        }

        public IntPtr SelectedTarget { get; private set; }

        protected override void OnSourceInitialized(EventArgs e)
        {
            _source = HwndSource.FromHwnd(new WindowInteropHelper(this).Handle);
            _source.AddHook(WindowProc);
        }

        public void Refresh()
        {
            _entries.Clear();
            // PostMessage でクエリを投げる
            NativeMethods.PostMessage(NativeMethods.HWND_BROADCAST, NativeMethods.WM_DEBUGSHIORI, _source.Handle, (IntPtr)NativeMethods.DS_QUERY_INTERFACE);
        }

        private IntPtr WindowProc(IntPtr hwnd, int msg, IntPtr wparam, IntPtr lparam, ref bool handled)
        {
            if (msg == NativeMethods.WM_COPYDATA)
            {
                // クエリの結果をリストに追加する
                var cds = (NativeMethods.COPYDATASTRUCT)Marshal.PtrToStructure(lparam, typeof(NativeMethods.COPYDATASTRUCT));
                var name = Marshal.PtrToStringAnsi(cds.lpData, cds.cbData);
                _entries.Add(new AttachEntry(name, wparam));
                handled = true;
                return (IntPtr)1;
            }
            return IntPtr.Zero;
        }

        private void AttachWindow_Loaded(object sender, RoutedEventArgs e)
        {
            Refresh();
        }

        private void RefreshButton_Click(object sender, RoutedEventArgs e)
        {
            Refresh();
        }

        private void AttachButton_Click(object sender, RoutedEventArgs e)
        {
            var entry = (AttachEntry)targetListView.SelectedItem;
            if (entry == null)
            {
                return;
            }
            SelectedTarget = entry.Handle;
            DialogResult = true;
        }

        private void CancelButton_Click(object sender, RoutedEventArgs e)
        {
            DialogResult = false;
        }
    }
}
