﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Windows.Threading;

using ICSharpCode.TextEditor;
using ICSharpCode.TextEditor.Actions;
using ICSharpCode.TextEditor.Document;

namespace Hosui.Controls
{
    /// <summary>
    /// CodeEditorControl.xaml の相互作用ロジック
    /// </summary>
    public partial class CodeEditorControl : UserControl
    {
        public CodeEditorControl()
        {
            InitializeComponent();
        }

        public TextEditorControl TextEditor
        {
            get { return textEditor; }
        }

        public int CurrentLine
        {
            get { return textEditor.ActiveTextAreaControl.TextArea.Caret.Line; }
            set
            {
                textEditor.ActiveTextAreaControl.TextArea.Caret.Line = value;
                textEditor.ActiveTextAreaControl.TextArea.SetCaretToDesiredColumn();
            }
        }

        public void Cut()
        {
            ExecAction(new Cut());
        }

        public void Copy()
        {
            ExecAction(new Copy());
        }

        public void Paste()
        {
            ExecAction(new Paste());
        }

        public void Delete()
        {
            ExecAction(new Delete());
        }

        public void SelectAll()
        {
            ExecAction(new SelectWholeDocument());
        }

        public void Undo()
        {
            Focus();
            textEditor.Undo();
        }

        public void Redo()
        {
            Focus();
            textEditor.Redo();
        }

        public void ToggleComment()
        {
            ExecAction(new ToggleComment());
        }

        public void Indent()
        {
        }

        public void Outdent()
        {
        }

        private void ExecAction(IEditAction action)
        {
            Focus();
            action.Execute(textEditor.ActiveTextAreaControl.TextArea);
        }

        public new void Focus()
        {
            Dispatcher.BeginInvoke((Action)(() => textEditor.Focus()), DispatcherPriority.Background);
        }

        public void JumpTo(int line)
        {
            textEditor.ActiveTextAreaControl.JumpTo(line);
        }
    }
}
