﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace Hosui.Utility
{
    internal static class Serializer
    {
        public static void Deserialize(string path, Dictionary<string, string> dic)
        {
            using (var reader = new StreamReader(path, Encoding.Default))
            {
                dic.Clear();
                while (reader.Peek() != -1)
                {
                    var line = reader.ReadLine().Trim();
                    if (line.Length == 0 || line.StartsWith("#") || line.StartsWith("//"))
                    {
                        continue;
                    }
                    int index = line.IndexOf(',');
                    if (index == -1)
                    {
                        continue;
                    }
                    var key = line.Substring(0, index).Trim().ToLower();
                    var value = line.Substring(index + 1).Trim();
                    if (value.Length == 0)
                    {
                        continue;
                    }
                    if (dic.ContainsKey(key))
                    {
                        dic[key] = value;
                    }
                    else
                    {
                        dic.Add(key, value);
                    }
                }
            }
        }
    }
}
