﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;

namespace Hosui
{
    static class NativeMethods
    {
        [DllImport("user32.dll")]
        public static extern IntPtr SendMessage(IntPtr hwnd, int msg, IntPtr wparam, IntPtr lparam);

        [DllImport("user32.dll")]
        public static extern IntPtr PostMessage(IntPtr hwnd, int msg, IntPtr wparam, IntPtr lparam);

        [DllImport("user32.dll")]
        public static extern IntPtr SendMessageTimeout(IntPtr hwnd, int msg, IntPtr wparam, IntPtr lparam, int flags, int timeout, ref int result);

        [DllImport("user32.dll", EntryPoint = "SendMessage")]
        public static extern IntPtr SendDirectSSTP(IntPtr hwnd, int msg, IntPtr wparam, ref COPYDATASTRUCT cds);

        [DllImport("user32.dll", EntryPoint = "SendMessageTimeout")]
        public static extern IntPtr SendDirectSSTPTimeout(IntPtr hwnd, int msg, IntPtr wparam, ref COPYDATASTRUCT cds, int flags, int timeout, ref int result);

        [DllImport("user32.dll")]
        public static extern bool IsWindow(IntPtr hwnd);

        [DllImport("user32.dll")]
        public static extern int RegisterWindowMessage(string str);

        [DllImport("kernel32.dll")]
        public static extern IntPtr OpenFileMapping(int access, bool inherit, string name);

        [DllImport("kernel32.dll")]
        public static extern IntPtr MapViewOfFile(IntPtr handle, int accessMode, int offsetHigh, int offsetLow, int mapSize);

        [DllImport("kernel32.dll")]
        public static extern bool UnmapViewOfFile(IntPtr address);

        [DllImport("kernel32.dll")]
        public static extern void CloseHandle(IntPtr handle);

        public const int WM_COPYDATA = 0x004A;

        public static readonly int WM_DEBUGSHIORI = RegisterWindowMessage("DebugShiori");

        public const int DS_QUERY_INTERFACE = 1;

        public const int FILE_MAP_READ = 0x04;

        public static readonly IntPtr HWND_BROADCAST = new IntPtr(0xFFFF);

        public struct COPYDATASTRUCT
        {
            public int dwData;
            public int cbData;
            public IntPtr lpData;
        }
    }
}
