﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.IO;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Interop;

namespace Hosui.IO
{
    public class FileEntry : INotifyPropertyChanged
    {
        public FileEntry(string path)
        {
            _name = Path.GetFileName(path);
            FullPath = path;
        }

        private string _name;

        public string Name
        {
            get { return _name; }
            set
            {
                if (_name != value)
                {
                    _name = value;
                    OnPropertyChanged("Name");
                }
            }
        }

        public string FullPath { get; private set; }

        private ImageSource _icon;

        public ImageSource Icon
        {
            get
            {
                if (_icon == null)
                {
                    var extension = Path.GetExtension(FullPath).ToLower();
                    if (!_cachedIcons.TryGetValue(extension, out _icon))
                    {
                        using (var icon = System.Drawing.Icon.ExtractAssociatedIcon(FullPath))
                        {
                            _icon = Imaging.CreateBitmapSourceFromHIcon(icon.Handle, new Int32Rect(0, 0, icon.Width, icon.Height), BitmapSizeOptions.FromWidthAndHeight(16, 16));
                            _icon.Freeze();
                            _cachedIcons.Add(extension, _icon);
                        }
                    }
                }
                return _icon;
            }
        }

        #region INotifyPropertyChanged メンバ

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string propertyName)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }

        #endregion

        private static readonly Dictionary<string, ImageSource> _cachedIcons = new Dictionary<string, ImageSource>();
    }
}
