﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.IO;
using System.Data;
using System.Linq;
using System.Windows;
using System.Windows.Threading;

using ICSharpCode.TextEditor.Document;

namespace Hosui
{
    /// <summary>
    /// App.xaml の相互作用ロジック
    /// </summary>
    public partial class App : Application
    {
        protected override void OnStartup(StartupEventArgs e)
        {
            System.Windows.Forms.Application.EnableVisualStyles();
            var directory = Path.GetDirectoryName(System.Windows.Forms.Application.ExecutablePath);
            _path = Path.Combine(directory, "setting.xml");
            Settings.Load(_path);
            HighlightingManager.Manager.AddSyntaxModeFileProvider(new FileSyntaxModeProvider(directory));
        }

        protected override void OnExit(ExitEventArgs e)
        {
            if (!string.IsNullOrEmpty(_path))
            {
                Settings.Save(_path);
            }
        }

        private string _path;

        private void Application_DispatcherUnhandledException(object sender, DispatcherUnhandledExceptionEventArgs e)
        {
            if (e.Exception is FileNotFoundException && ((FileNotFoundException)e.Exception).FileName.StartsWith("ICSharpCode.TextEditor"))
            {
                MessageBox.Show("ICSharpCode.TextEditor.dll が必要になります。下記のページからダウンロードしてください。\n\nic#code http://www.icsharpcode.net/OpenSource/SD", "豊水", MessageBoxButton.OK, MessageBoxImage.Stop);
            }
            else
            {
                MessageBox.Show("内部エラーが発生しました。", "豊水", MessageBoxButton.OK, MessageBoxImage.Error);
            }
            e.Handled = true;
            Shutdown();
        }
    }
}
