use utf8;
use lib 'lib';
use Encode qw/decode/;
use File::Spec;
use YAML;
use Mojo::UserAgent;

$| = 1;

my ($setting,$set) = load_settings('mknktt.yaml');

if($setting->{term_encoding}){
	binmode STDIN,':encoding('.$setting->{term_encoding}.')';
	binmode STDOUT,':encoding('.$setting->{term_encoding}.')';
	binmode STDERR,':encoding('.$setting->{term_encoding}.')';
}

my $html_content = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><html><head></head><body></body></html>';

my $head_content = Mojo::DOM->new(<<"EOM");
<meta http-equiv="Content-Type" content="text/html; charset=$$setting{html_encoding}" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<link rel="stylesheet" href="$$setting{css}" type="text/css" />
EOM

mkdir $setting->{target_dir} unless -d $setting->{target_dir};

my $ua = Mojo::UserAgent->new();

for my $group (@$set){
	print '['.$group->{name}.']を処理中です',"\n";
	my $html = Mojo::DOM->new($html_content);
	$html->xml(1);
	$html->at('head')->append_content($head_content);
	for my $table (@{$group->{tables}}){
		my $table_day_kind_list;
		for my $day_kind (@{$table->{day_kind}}){
			push @{$table->{timetable_list}}, get_timetable($setting->{day_kind_list}->{$day_kind},$table->{from},$table->{to});
		}
		$table->{html} = build_html($table->{timetable_list}, $table->{title}, $table->{day_kind}, $table->{notes});
		$html->at('body')->append_content($table->{html});
	}
	open my $fh,'>:encoding('.$setting->{html_encoding}.')',File::Spec->catfile($setting->{target_dir},$group->{name}.'.html');
	flock $fh,2;
	print $fh $html->to_xml;
	close $fh;
}

print 'HTMLファイルはディレクトリ[',$setting->{target_dir},']に保存されました',"\n";
print '完了しました',"\n";

exit;

sub get_station_number{
	my $name = shift;
	my $type = shift;
	my $stopflg = $type eq 'from' ? 0 : 1;
	my $url = Mojo::URL->new($setting->{url_root})->path($setting->{path_station_number});
	my $tx = $ua->post_form($url => $setting->{request_encoding} => {stopflg => $stopflg, $type.'name' => $name});
	my ($cd) = decode($setting->{responce_encoding}, ''.$tx->res->body) =~ m@${type}cd=([0-9-]+).*?>${name}<@is;
	die '[',$name,']という停留所は見つかりませんでした' unless defined $cd;
	return $cd;
}

sub get_timetable{
	my $day = shift;
	my $from = shift;
	my $to = shift;
	if($from !~ /^[-0-9]+$/){
		$from = get_station_number($from,'from');
	}
	if($to !~ /^[-0-9]+$/){
		$to = get_station_number($to,'to');
	}
	my $url = Mojo::URL->new($setting->{url_root})->path($setting->{path_request})->query(daykind => $day, fromcd => $from, tocd => $to);
	my $tx = $ua->get($url);
	my $table = decode($setting->{responce_encoding}, ''.$tx->res->body);

	my ($dests) = $table =~ m@行先（経由）</th>(.*?)</tr>@is;
	die '時刻表が[',$url,']から取得できませんでした' unless $dests;
	my @dest = map {tr/０１２３４５６７８９/0123456789/;$_} $dests =~ m@<b>(.*?)</b>@isg;

	my %hours = $table =~ m@(\d+)&nbsp;&nbsp;&nbsp;&nbsp;.*?</th>(.*?)</tr>@isg;
	my $timetable;
	for my $hour (keys %hours){
		my @column = $hours{$hour} =~ m@>([^a]*?)</td>@isg;
		s/&nbsp;// for @column;
		my @times;
		for my $n (0..$#column){
			push @times, map {s@\D@@g;{line => 'line'.$dest[$n], time => sprintf('%02d',$_)}} split / |<br>/i,$column[$n];
		}
		$timetable->{$hour} = [sort {$a->{time} <=> $b->{time}} @times];
	}
	return $timetable;
}

sub build_html{
	my $set = shift;
	my $title = shift;
	my $day_kind = shift;
	my $notes = shift;
	my $colspan = $#$day_kind + 2;
	my $table = Mojo::DOM->new('<table><thead><tr class="title"><th colspan="'.$colspan.'">'.$title.'</th></tr><tr class="day_kind"><th> </th>'.(join '',map {'<td class="'.$_.'">'.$setting->{day_kind_label_list}->{$_}.'</td>'} @$day_kind).'</tr></thead><tfoot></tfoot><tbody></tbody></table>');
	$table->at('tfoot')->append_content('<tr><td colspan="'.$colspan.'">'.$notes.'</td></tr>');

	for my $key (sort {$a == 0 ? 1 : $b == 0 ? -1 : $a <=> $b} keys %{$set->[0]}){
		my @td;
		for my $timetable (@$set){
			my $list = join '',map {'<li class="'.$_->{line}.'">'.$_->{time}.'</li>'} @{$timetable->{$key}};
			push @td,$list;
		}
		next unless join '',@td;
		$table->at('tbody')->append_content('<tr>'.'<th class="hour">'.$key.'</th>'.(join '',map {'<td><ul>'.$_.'</ul></td>'} @td).'</tr>'."\n");
	}
	
	return $table;
}

sub load_settings{
	my $file = shift;
	open my $fh,'<:encoding(sjis)',$file;
	flock $fh,1;
	seek $fh,0,0;
	my @ret = do{local $/;Load(<$fh>);};
	close $fh;
	return @ret;
}
