#!/usr/bin/perl
use 5.006; # not checked
my $dd = 'dd'; # PLEASE SET "dd" command name (ex. '/usr/bin/dd'(linux), 'C:\usr\bin\dd.exe'(windows) or 'dd')
my $if = '\\\\?\\Device\\Harddisk0\\Partition0'; # PLEASE SET HDD device name (ex. '/dev/sda'(linux) or '\\\\?\\Device\\Harddisk0\\Partition0'(dd for windows(http://www.chrysocome.net/dd)))
my $first_offset = 0; # PLEASE SET the start sector of the first extend partition
my $null = 'NUL'; # PLEASE SET null device (ex. '/dev/null'(linux) or 'NUL'(windows))
my $of = 'dump'; # temp file name
my $sector_size = 512; # bytes per sector
my $block_size = 1024; # bytes per block

my %types = (
	0x07 => 'NTFS',
	0x17 => 'HiddenNTFS',
	0x05 => 'EXTEND',
	0x0F => 'EXTEND(LBA)',
	0x0B => 'FAT32',
	0x1B => 'HiddenFAT32',
	0x04 => 'FAT16(<32MB)',
	0x06 => 'FAT16(>32MB)',
	0x82 => 'Linux Swap',
	0x83 => 'Linux ext',
);

my %opt = (if => $if, of => $of, bs => $sector_size, count => 1);

findpart(0,$first_offset);

unlink $of;

exit;

sub findpart{
	my $offset = shift;
	my $first_offset = shift;
	$opt{skip} = $first_offset + $offset;
	my $cmd = join ' ', $dd, map {$_.'='.$opt{$_}} keys %opt;
	qx/$cmd 2> $null/;
	my $table;
	open my $fh, '<', $of;
	flock $fh,1;
	binmode $fh;
	seek $fh,0x1BE,0;
	read $fh,$table,0x40;
	close $fh;
	my $local_partition;
	for my $n (0..3){
		$local_partition->[$n]->{raw} = substr $table, 0x10 * $n, 0x10;
		my $praw = $local_partition->[$n]->{raw};
		$local_partition->[$n]->{boot} = unpack 'c', substr $praw, 0, 1;
		$local_partition->[$n]->{type} = unpack 'c', substr $praw, 4, 1;
		$local_partition->[$n]->{begin} = unpack 'l<', substr $praw, 8, 4;
		$local_partition->[$n]->{content} = unpack 'l<', substr $praw, 12, 4;
		if($local_partition->[$n]->{type} == 0x05 || $local_partition->[$n]->{type} == 0x0F || $local_partition->[$n]->{type} == 0x85){
			printpart($local_partition->[$n], $first_offset);
			return findpart($local_partition->[1]->{begin},$first_offset);
		}elsif($local_partition->[$n]->{type} != 0x00){
			printpart($local_partition->[$n], $first_offset + $offset);
		}
	}
}

sub printpart{
	my $p = shift;
	my $offset = shift;
	printf " bootflag=%-3s type=%-12s\n start=   %10d sectors %6.1f GB %12s blocks %12s B\n(relative %10d sectors %6.1f GB offset= %10d sectors)\n content= %10d sectors %6.1f GB\n%s\n",
		$p->{boot}?'YES':'NO',
		$types{$p->{type}}||$p->{type},
		$offset+$p->{begin},
		($offset+$p->{begin})*$sector_size/1024**3,
		($offset+$p->{begin})*$sector_size/$block_size,
		($offset+$p->{begin})*$sector_size,
		$p->{begin},
		$p->{begin}*$sector_size/1024**3,
		$offset,
		$p->{content},
		$p->{content}*$sector_size/1024**3,
		'-'x79
		;
}
